/*************************************************/
/* Examples Program For "ET-dsPIC30F2010"  Board */
/* Hardware    : ET-dsPIC30F2010 TRAINING KIT V1 */
/* Target MCU  : dsPIC30F2010                    */
/*       	   : X-TAL : 7.3728 MHz              */
/*             : Run 117.9648MHz                 */
/*             : Selec OSC Mode = XT w/PLL 16x   */
/* Compiler    : MPLAB + C30 V1.33  		     */
/* Last Update : 1/October/2005                  */
/* Function    : Example Use INT0,INT1 Interrupt */
/*             : LED Blink on RB0                */	
/*************************************************/
/* INT0(RE8) Toggle RB0(ON/OFF LED) on Interrupt */
/* INT1(RD0) Tiggle RB1(ON/OFF LED) on Interrupt */
/* Connect RE8 to SW1 & Connect RB0 to LED1      */
/* Connect RD0 to SW2 & Connect RB1 to LED2      */
/*  -> Press SW1 Toggle LED1                     */
/*  -> Press SW2 toggle LED2                     */
/*************************************************/

#include "p30f2010a2.h"	                               		// dsPIC30F2010 MPU Register
#include "ports.h"											// Used Port & Interrupt Function Library

/* Setup Configuration For ET-dsPIC30F2010 */
_FOSC(CSW_FSCM_ON & XT_PLL16);								// Enable Clock Switching,Enable Fail-Salf Clock
                                                            // Closk Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_ON & BORV_45 & PWRT_64 & MCLR_EN);			// Enable Brown-Out = 4.5V,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End   Configuration For ET-dsPIC30F2010 */

/* pototype  section */
void delay(unsigned long int);								// Delay Time Function

/**************************/
/* INT0 Interrupt Service */
/* Active by Port Pin RE8 */
/**************************/
void _ISR _INT0Interrupt(void)
{  
  LATBbits.LATB0 = !LATBbits.LATB0; 						// Toggle Output RB0 (0 = ON LED, 1 = OFF LED)
  while(PORTEbits.RE8 |= 1);								// Wait INT0 Signal Release
  delay(100000);											// Debounce
  IFS0bits.INT0IF = 0;										// Reset INT0 Interrupt Flag
}

/**************************/
/* INT1 Interrupt Service */
/* Active by Port Pin RD0 */
/**************************/
void _ISR _INT1Interrupt(void)
{  
  LATBbits.LATB1 = !LATBbits.LATB1; 						// Toggle Output RB1 (0 = ON LED, 1 = OFF LED)
  while(PORTDbits.RD0 |= 1);								// Wait INT1 Signal Release
  delay(100000);											// Debounce
  IFS1bits.INT1IF = 0;										// Reset INT1 Interrupt Flag
}


int main(void)
{  
  TRISBbits.TRISB0 = 0;										// Config RB0 = Output
  TRISBbits.TRISB1 = 0;										// Config RB1 = Output

  ConfigINT0(FALLING_EDGE_INT &								// Falling Edge Trigger Interrupt
             EXT_INT_ENABLE &								// Enable INT0 Interrupt 
             EXT_INT_PRI_6);								// INT0 Interrupt Priority = 6
             
  ConfigINT1(FALLING_EDGE_INT &								// Falling Edge Trigger Interrupt
             EXT_INT_ENABLE &								// Enable INT1 Interrupt 
             EXT_INT_PRI_7);								// INT1 Interrupt Priority = 7

  LATBbits.LATB0 = 1; 										// Output RB0 = "1" (OFF LED)
  LATBbits.LATB1 = 1; 										// Output RB1 = "1" (OFF LED)

  // Loop Continue
  while(1);
												
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}
